<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

### Table of Contents

-   [rotate][1]
-   [extract][2]
-   [flip][3]
-   [flop][4]
-   [sharpen][5]
-   [median][6]
-   [blur][7]
-   [extend][8]
-   [flatten][9]
-   [trim][10]
-   [gamma][11]
-   [negate][12]
-   [normalise][13]
-   [normalize][14]
-   [convolve][15]
-   [threshold][16]
-   [boolean][17]
-   [linear][18]

## rotate

Rotate the output image by either an explicit angle
or auto-orient based on the EXIF `Orientation` tag.

If an angle is provided, it is converted to a valid 90/180/270deg rotation.
For example, `-450` will produce a 270deg rotation.

If no angle is provided, it is determined from the EXIF data.
Mirroring is supported and may infer the use of a flip operation.

The use of `rotate` implies the removal of the EXIF `Orientation` tag, if any.

Method order is important when both rotating and extracting regions,
for example `rotate(x).extract(y)` will produce a different result to `extract(y).rotate(x)`.

**Parameters**

-   `angle` **[Number][19]** angle of rotation, must be a multiple of 90. (optional, default `auto`)

**Examples**

```javascript
const pipeline = sharp()
  .rotate()
  .resize(null, 200)
  .toBuffer(function (err, outputBuffer, info) {
    // outputBuffer contains 200px high JPEG image data,
    // auto-rotated using EXIF Orientation tag
    // info.width and info.height contain the dimensions of the resized image
  });
readableStream.pipe(pipeline);
```

-   Throws **[Error][20]** Invalid parameters

Returns **Sharp** 

## extract

Extract a region of the image.

-   Use `extract` before `resize` for pre-resize extraction.
-   Use `extract` after `resize` for post-resize extraction.
-   Use `extract` before and after for both.

**Parameters**

-   `options` **[Object][21]** 
    -   `options.left` **[Number][19]** zero-indexed offset from left edge
    -   `options.top` **[Number][19]** zero-indexed offset from top edge
    -   `options.width` **[Number][19]** dimension of extracted image
    -   `options.height` **[Number][19]** dimension of extracted image

**Examples**

```javascript
sharp(input)
  .extract({ left: left, top: top, width: width, height: height })
  .toFile(output, function(err) {
    // Extract a region of the input image, saving in the same format.
  });
```

```javascript
sharp(input)
  .extract({ left: leftOffsetPre, top: topOffsetPre, width: widthPre, height: heightPre })
  .resize(width, height)
  .extract({ left: leftOffsetPost, top: topOffsetPost, width: widthPost, height: heightPost })
  .toFile(output, function(err) {
    // Extract a region, resize, then extract from the resized image
  });
```

-   Throws **[Error][20]** Invalid parameters

Returns **Sharp** 

## flip

Flip the image about the vertical Y axis. This always occurs after rotation, if any.
The use of `flip` implies the removal of the EXIF `Orientation` tag, if any.

**Parameters**

-   `flip` **[Boolean][22]**  (optional, default `true`)

Returns **Sharp** 

## flop

Flop the image about the horizontal X axis. This always occurs after rotation, if any.
The use of `flop` implies the removal of the EXIF `Orientation` tag, if any.

**Parameters**

-   `flop` **[Boolean][22]**  (optional, default `true`)

Returns **Sharp** 

## sharpen

Sharpen the image.
When used without parameters, performs a fast, mild sharpen of the output image.
When a `sigma` is provided, performs a slower, more accurate sharpen of the L channel in the LAB colour space.
Separate control over the level of sharpening in "flat" and "jagged" areas is available.

**Parameters**

-   `sigma` **[Number][19]?** the sigma of the Gaussian mask, where `sigma = 1 + radius / 2`.
-   `flat` **[Number][19]** the level of sharpening to apply to "flat" areas. (optional, default `1.0`)
-   `jagged` **[Number][19]** the level of sharpening to apply to "jagged" areas. (optional, default `2.0`)


-   Throws **[Error][20]** Invalid parameters

Returns **Sharp** 

## median

Apply median filter.
When used without parameters the default window is 3x3.

**Parameters**

-   `size` **[Number][19]** square mask size: size x size (optional, default `3`)


-   Throws **[Error][20]** Invalid parameters

Returns **Sharp** 

## blur

Blur the image.
When used without parameters, performs a fast, mild blur of the output image.
When a `sigma` is provided, performs a slower, more accurate Gaussian blur.

**Parameters**

-   `sigma` **[Number][19]?** a value between 0.3 and 1000 representing the sigma of the Gaussian mask, where `sigma = 1 + radius / 2`.


-   Throws **[Error][20]** Invalid parameters

Returns **Sharp** 

## extend

Extends/pads the edges of the image with the colour provided to the `background` method.
This operation will always occur after resizing and extraction, if any.

**Parameters**

-   `extend` **([Number][19] \| [Object][21])** single pixel count to add to all edges or an Object with per-edge counts
    -   `extend.top` **[Number][19]?** 
    -   `extend.left` **[Number][19]?** 
    -   `extend.bottom` **[Number][19]?** 
    -   `extend.right` **[Number][19]?** 

**Examples**

```javascript
// Resize to 140 pixels wide, then add 10 transparent pixels
// to the top, left and right edges and 20 to the bottom edge
sharp(input)
  .resize(140)
  .background({r: 0, g: 0, b: 0, alpha: 0})
  .extend({top: 10, bottom: 20, left: 10, right: 10})
  ...
```

-   Throws **[Error][20]** Invalid parameters

Returns **Sharp** 

## flatten

Merge alpha transparency channel, if any, with `background`.

**Parameters**

-   `flatten` **[Boolean][22]**  (optional, default `true`)

Returns **Sharp** 

## trim

Trim "boring" pixels from all edges that contain values within a percentage similarity of the top-left pixel.

**Parameters**

-   `tolerance` **[Number][19]** value between 1 and 99 representing the percentage similarity. (optional, default `10`)


-   Throws **[Error][20]** Invalid parameters

Returns **Sharp** 

## gamma

Apply a gamma correction by reducing the encoding (darken) pre-resize at a factor of `1/gamma`
then increasing the encoding (brighten) post-resize at a factor of `gamma`.
This can improve the perceived brightness of a resized image in non-linear colour spaces.
JPEG and WebP input images will not take advantage of the shrink-on-load performance optimisation
when applying a gamma correction.

**Parameters**

-   `gamma` **[Number][19]** value between 1.0 and 3.0. (optional, default `2.2`)


-   Throws **[Error][20]** Invalid parameters

Returns **Sharp** 

## negate

Produce the "negative" of the image.

**Parameters**

-   `negate` **[Boolean][22]**  (optional, default `true`)

Returns **Sharp** 

## normalise

Enhance output image contrast by stretching its luminance to cover the full dynamic range.

**Parameters**

-   `normalise` **[Boolean][22]**  (optional, default `true`)

Returns **Sharp** 

## normalize

Alternative spelling of normalise.

**Parameters**

-   `normalize` **[Boolean][22]**  (optional, default `true`)

Returns **Sharp** 

## convolve

Convolve the image with the specified kernel.

**Parameters**

-   `kernel` **[Object][21]** 
    -   `kernel.width` **[Number][19]** width of the kernel in pixels.
    -   `kernel.height` **[Number][19]** width of the kernel in pixels.
    -   `kernel.kernel` **[Array][23]&lt;[Number][19]>** Array of length `width*height` containing the kernel values.
    -   `kernel.scale` **[Number][19]** the scale of the kernel in pixels. (optional, default `sum`)
    -   `kernel.offset` **[Number][19]** the offset of the kernel in pixels. (optional, default `0`)

**Examples**

```javascript
sharp(input)
  .convolve({
    width: 3,
    height: 3,
    kernel: [-1, 0, 1, -2, 0, 2, -1, 0, 1]
  })
  .raw()
  .toBuffer(function(err, data, info) {
    // data contains the raw pixel data representing the convolution
    // of the input image with the horizontal Sobel operator
  });
```

-   Throws **[Error][20]** Invalid parameters

Returns **Sharp** 

## threshold

Any pixel value greather than or equal to the threshold value will be set to 255, otherwise it will be set to 0.

**Parameters**

-   `threshold` **[Number][19]** a value in the range 0-255 representing the level at which the threshold will be applied. (optional, default `128`)
-   `options` **[Object][21]?** 
    -   `options.greyscale` **[Boolean][22]** convert to single channel greyscale. (optional, default `true`)
    -   `options.grayscale` **[Boolean][22]** alternative spelling for greyscale. (optional, default `true`)


-   Throws **[Error][20]** Invalid parameters

Returns **Sharp** 

## boolean

Perform a bitwise boolean operation with operand image.

This operation creates an output image where each pixel is the result of
the selected bitwise boolean `operation` between the corresponding pixels of the input images.

**Parameters**

-   `operand` **([Buffer][24] \| [String][25])** Buffer containing image data or String containing the path to an image file.
-   `operator` **[String][25]** one of `and`, `or` or `eor` to perform that bitwise operation, like the C logic operators `&`, `|` and `^` respectively.
-   `options` **[Object][21]?** 
    -   `options.raw` **[Object][21]?** describes operand when using raw pixel data.
        -   `options.raw.width` **[Number][19]?** 
        -   `options.raw.height` **[Number][19]?** 
        -   `options.raw.channels` **[Number][19]?** 


-   Throws **[Error][20]** Invalid parameters

Returns **Sharp** 

## linear

Apply the linear formula a \* input + b to the image (levels adjustment)

**Parameters**

-   `a` **[Number][19]** multiplier (optional, default `1.0`)
-   `b` **[Number][19]** offset (optional, default `0.0`)


-   Throws **[Error][20]** Invalid parameters

Returns **Sharp** 

[1]: #rotate

[2]: #extract

[3]: #flip

[4]: #flop

[5]: #sharpen

[6]: #median

[7]: #blur

[8]: #extend

[9]: #flatten

[10]: #trim

[11]: #gamma

[12]: #negate

[13]: #normalise

[14]: #normalize

[15]: #convolve

[16]: #threshold

[17]: #boolean

[18]: #linear

[19]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Number

[20]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Error

[21]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object

[22]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Boolean

[23]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Array

[24]: https://nodejs.org/api/buffer.html

[25]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String
