<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

### Table of Contents

-   [Sharp][1]
    -   [format][2]
    -   [versions][3]
-   [queue][4]

## Sharp

**Parameters**

-   `input` **([Buffer][5] \| [String][6])?** if present, can be
     a Buffer containing JPEG, PNG, WebP, GIF, SVG, TIFF or raw pixel image data, or
     a String containing the path to an JPEG, PNG, WebP, GIF, SVG or TIFF image file.
     JPEG, PNG, WebP, GIF, SVG, TIFF or raw pixel image data can be streamed into the object when not present.
-   `options` **[Object][7]?** if present, is an Object with optional attributes.
    -   `options.failOnError` **[Boolean][8]** by default apply a "best effort"
         to decode images, even if the data is corrupt or invalid. Set this flag to true
         if you'd rather halt processing and raise an error when loading invalid images. (optional, default `false`)
    -   `options.density` **[Number][9]** integral number representing the DPI for vector images. (optional, default `72`)
    -   `options.raw` **[Object][7]?** describes raw pixel input image data. See `raw()` for pixel ordering.
        -   `options.raw.width` **[Number][9]?** 
        -   `options.raw.height` **[Number][9]?** 
        -   `options.raw.channels` **[Number][9]?** 1-4
    -   `options.create` **[Object][7]?** describes a new image to be created.
        -   `options.create.width` **[Number][9]?** 
        -   `options.create.height` **[Number][9]?** 
        -   `options.create.channels` **[Number][9]?** 3-4
        -   `options.create.background` **([String][6] \| [Object][7])?** parsed by the [color][10] module to extract values for red, green, blue and alpha.

**Examples**

```javascript
sharp('input.jpg')
  .resize(300, 200)
  .toFile('output.jpg', function(err) {
    // output.jpg is a 300 pixels wide and 200 pixels high image
    // containing a scaled and cropped version of input.jpg
  });
```

```javascript
// Read image data from readableStream,
// resize to 300 pixels wide,
// emit an 'info' event with calculated dimensions
// and finally write image data to writableStream
var transformer = sharp()
  .resize(300)
  .on('info', function(info) {
    console.log('Image height is ' + info.height);
  });
readableStream.pipe(transformer).pipe(writableStream);
```

```javascript
// Create a blank 300x200 PNG image of semi-transluent red pixels
sharp({
  create: {
    width: 300,
    height: 200,
    channels: 4,
    background: { r: 255, g: 0, b: 0, alpha: 128 }
  }
})
.png()
.toBuffer()
.then( ... );
```

-   Throws **[Error][11]** Invalid parameters

Returns **[Sharp][12]** 

### format

An Object containing nested boolean values representing the available input and output formats/methods.

**Examples**

```javascript
console.log(sharp.format);
```

Returns **[Object][7]** 

### versions

An Object containing the version numbers of libvips and its dependencies.

**Examples**

```javascript
console.log(sharp.versions);
```

## queue

An EventEmitter that emits a `change` event when a task is either:

-   queued, waiting for _libuv_ to provide a worker thread
-   complete

**Examples**

```javascript
sharp.queue.on('change', function(queueLength) {
  console.log('Queue contains ' + queueLength + ' task(s)');
});
```

[1]: #sharp

[2]: #format

[3]: #versions

[4]: #queue

[5]: https://nodejs.org/api/buffer.html

[6]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String

[7]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object

[8]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Boolean

[9]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Number

[10]: https://www.npmjs.org/package/color

[11]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Error

[12]: #sharp
