<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

### Table of Contents

-   [overlayWith][1]

## overlayWith

Overlay (composite) an image over the processed (resized, extracted etc.) image.

The overlay image must be the same size or smaller than the processed image.
If both `top` and `left` options are provided, they take precedence over `gravity`.

If the overlay image contains an alpha channel then composition with premultiplication will occur.

**Parameters**

-   `overlay` **([Buffer][2] \| [String][3])** Buffer containing image data or String containing the path to an image file.
-   `options` **[Object][4]?** 
    -   `options.gravity` **[String][3]** gravity at which to place the overlay. (optional, default `'centre'`)
    -   `options.top` **[Number][5]?** the pixel offset from the top edge.
    -   `options.left` **[Number][5]?** the pixel offset from the left edge.
    -   `options.tile` **[Boolean][6]** set to true to repeat the overlay image across the entire image with the given `gravity`. (optional, default `false`)
    -   `options.cutout` **[Boolean][6]** set to true to apply only the alpha channel of the overlay image to the input image, giving the appearance of one image being cut out of another. (optional, default `false`)
    -   `options.density` **[Number][5]** integral number representing the DPI for vector overlay image. (optional, default `72`)
    -   `options.raw` **[Object][4]?** describes overlay when using raw pixel data.
        -   `options.raw.width` **[Number][5]?** 
        -   `options.raw.height` **[Number][5]?** 
        -   `options.raw.channels` **[Number][5]?** 
    -   `options.create` **[Object][4]?** describes a blank overlay to be created.
        -   `options.create.width` **[Number][5]?** 
        -   `options.create.height` **[Number][5]?** 
        -   `options.create.channels` **[Number][5]?** 3-4
        -   `options.create.background` **([String][3] \| [Object][4])?** parsed by the [color][7] module to extract values for red, green, blue and alpha.

**Examples**

```javascript
sharp('input.png')
  .rotate(180)
  .resize(300)
  .flatten()
  .background('#ff6600')
  .overlayWith('overlay.png', { gravity: sharp.gravity.southeast } )
  .sharpen()
  .withMetadata()
  .quality(90)
  .webp()
  .toBuffer()
  .then(function(outputBuffer) {
    // outputBuffer contains upside down, 300px wide, alpha channel flattened
    // onto orange background, composited with overlay.png with SE gravity,
    // sharpened, with metadata, 90% quality WebP image data. Phew!
  });
```

-   Throws **[Error][8]** Invalid parameters

Returns **Sharp** 

[1]: #overlaywith

[2]: https://nodejs.org/api/buffer.html

[3]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String

[4]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object

[5]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Number

[6]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Boolean

[7]: https://www.npmjs.org/package/color

[8]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Error
