<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

### Table of Contents

-   [background][1]
-   [greyscale][2]
-   [grayscale][3]
-   [toColourspace][4]
-   [toColorspace][5]

## background

Set the background for the `embed`, `flatten` and `extend` operations.
The default background is `{r: 0, g: 0, b: 0, alpha: 1}`, black without transparency.

Delegates to the _color_ module, which can throw an Error
but is liberal in what it accepts, clipping values to sensible min/max.
The alpha value is a float between `0` (transparent) and `1` (opaque).

**Parameters**

-   `rgba` **([String][6] \| [Object][7])** parsed by the [color][8] module to extract values for red, green, blue and alpha.


-   Throws **[Error][9]** Invalid parameter

Returns **Sharp** 

## greyscale

Convert to 8-bit greyscale; 256 shades of grey.
This is a linear operation. If the input image is in a non-linear colour space such as sRGB, use `gamma()` with `greyscale()` for the best results.
By default the output image will be web-friendly sRGB and contain three (identical) color channels.
This may be overridden by other sharp operations such as `toColourspace('b-w')`,
which will produce an output image containing one color channel.
An alpha channel may be present, and will be unchanged by the operation.

**Parameters**

-   `greyscale` **[Boolean][10]**  (optional, default `true`)

Returns **Sharp** 

## grayscale

Alternative spelling of `greyscale`.

**Parameters**

-   `grayscale` **[Boolean][10]**  (optional, default `true`)

Returns **Sharp** 

## toColourspace

Set the output colourspace.
By default output image will be web-friendly sRGB, with additional channels interpreted as alpha channels.

**Parameters**

-   `colourspace` **[String][6]?** output colourspace e.g. `srgb`, `rgb`, `cmyk`, `lab`, `b-w` [...][11]


-   Throws **[Error][9]** Invalid parameters

Returns **Sharp** 

## toColorspace

Alternative spelling of `toColourspace`.

**Parameters**

-   `colorspace` **[String][6]?** output colorspace.


-   Throws **[Error][9]** Invalid parameters

Returns **Sharp** 

[1]: #background

[2]: #greyscale

[3]: #grayscale

[4]: #tocolourspace

[5]: #tocolorspace

[6]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String

[7]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object

[8]: https://www.npmjs.org/package/color

[9]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Error

[10]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Boolean

[11]: https://github.com/jcupitt/libvips/blob/master/libvips/iofuncs/enumtypes.c#L568
