// This gives you default context menu (cut, copy, paste)
// in all input fields and textareas across your app.

(function () {
  'use strict';
  var remote = require('electron').remote;
  var shell = remote.shell;
  var Menu = remote.Menu;
  var MenuItem = remote.MenuItem;

  var currentImagePath = '';

  var isAnyTextSelected = function () {
    return window.getSelection().toString() !== '';
  };

  var cut = new MenuItem({
    label: "Cut",
    click: function () {
      document.execCommand("cut");
    }
  });

  var copy = new MenuItem({
    label: "Copy",
    click: function () {
      document.execCommand("copy");
    }
  });

  var paste = new MenuItem({
    label: "Paste",
    click: function () {
      document.execCommand("paste");
    }
  });

  var reveal = new MenuItem({
    label: "Show in Folder",
    click: function () {
      shell.showItemInFolder(currentImagePath);
    }
  });
  var openItem = new MenuItem({
    label: "Open Item",
    click: function () {
      shell.openItem(currentImagePath);
    }
  })

  var normalMenu = new Menu();
  normalMenu.append(copy);

  var textEditingMenu = new Menu();
  textEditingMenu.append(cut);
  textEditingMenu.append(copy);
  textEditingMenu.append(paste);

  var imageMenu = new Menu();
  imageMenu.append(reveal);
  imageMenu.append(openItem);

  document.addEventListener('contextmenu', function (e) {
    switch (e.target.nodeName) {
      case 'TEXTAREA':
      case 'INPUT':
        e.preventDefault();
        textEditingMenu.popup(remote.getCurrentWindow());
        break;
      case 'IMG':
        if (e.target.className.indexOf('no_default_context_menu') < 0) {
            e.preventDefault();
            currentImagePath = decodeURI(e.target.src.replace("file://", ""));
            imageMenu.popup(remote.getCurrentWindow());
        }
        break;
      default:
        if (isAnyTextSelected()) {
          e.preventDefault();
          normalMenu.popup(remote.getCurrentWindow());
        }
    }
  }, false);

}());

